ALTER TRIGGER L_M29_BU
ACTIVE BEFORE UPDATE POSITION 0
as
declare variable DELTA DOUBLE PRECISION;
begin

   new.currdate = 'now';

   if ( old.id_self <> new.id_self ) then
      update l_m29_spis s
      set s.id_rec = new.id_self
      where ( s.id_m29 = old.id_m29 ) and
            ( s.id_rec = old.id_self );

/* 3.2 */
   if ( new.koll is null ) then
      new.koll = 0;
   if ( new.normarash is null ) then
      new.normarash = 0;
   if ( new.rashodall is null ) then
      new.rashodall = 0;
   if ( new.csmetn is null ) then
      new.csmetn = 0;
   if ( new.csmetnall is null ) then
      new.csmetnall = 0;
end
^

CREATE TRIGGER L_M29_SPIS_BU FOR L_M29_SPIS
ACTIVE BEFORE UPDATE POSITION 0
as
begin
/* 3.2 */
   if ( new.ccurrent is null ) then
      new.ccurrent = 0;
   if ( new.ccurrentall is null ) then
      new.ccurrentall = 0;
   if ( new.kollexec is null ) then
      new.kollexec = 0;
   if ( new.rashodplan is null ) then
      new.rashodplan = 0;
   if ( new.rashodfact is null ) then
      new.rashodfact = 0;
   if ( new.rashoddiff is null ) then
      new.rashoddiff = 0;
   if ( new.spissebest is null ) then
      new.spissebest = 0;
end
^


alter PROCEDURE L_M29_ASSIGN_ON_PROCENTOV(
    ID_M29 INTEGER,
    ID_PROCENT INTEGER,
    PROCENT_ARR BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    PROCENT_CNT INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID_SELF INTEGER,
    KOLL DOUBLE PRECISION,
    IS_FOUND INTEGER)
AS
DECLARE VARIABLE ASMETA_ID INTEGER;
DECLARE VARIABLE ASMETARES_ID INTEGER;
DECLARE VARIABLE NUMBER3 INTEGER;
DECLARE VARIABLE I INTEGER;
DECLARE VARIABLE SM_KOLL DOUBLE PRECISION;
DECLARE VARIABLE NORMARASH DOUBLE PRECISION;
DECLARE VARIABLE ID_SOURCE INTEGER;
DECLARE VARIABLE USE_BLOB INTEGER;
DECLARE VARIABLE ID_BLOB_GEN INTEGER;
DECLARE VARIABLE RES_NOMERROD INTEGER;
DECLARE VARIABLE SM_ID INTEGER;
DECLARE VARIABLE NOMERROD1 INTEGER;
begin
   if ( not PROCENT_ARR is null ) then
   begin
       /* clear blob */
       ID_BLOB_GEN = GEN_ID(B_GEN_TEMP, 1);
       INSERT INTO B_TEMP_BLOB(ID, BLOB1) VALUES (:ID_BLOB_GEN, :PROCENT_ARR);
       SELECT BLOB1 FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN INTO :PROCENT_ARR;
       DELETE FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN;
   end

   if ( PROCENT_CNT < 1 ) then
      exception ae_param_not_found;
   if ( ( ( PROCENT_CNT > 1 ) or ( ID_PROCENT is null ) ) and ( PROCENT_ARR is null ) ) then
      exception ae_param_not_found;

   USE_BLOB = 0;
   if ( ( PROCENT_CNT > 1 ) or ( ID_PROCENT is null ) ) then
      USE_BLOB = 1;

   for select ID_SELF , ASMETA_ID , ASMETARES_ID , NUMBER3
       from l_m29  where ID_M29 = :ID_M29
       order by ID_M29 , IDHIER , NUMBER1 , NUMBER2 , NUMBER3
       into ID_SELF , ASMETA_ID , ASMETARES_ID , NUMBER3
   do
      if ( NUMBER3 = 0 ) then
      begin
         IS_FOUND = 0;
         KOLL = 0.0;

         if ( ( not ASMETA_ID is null ) and ( ASMETA_ID <> 0 ) or
              ( ( not ASMETARES_ID is null ) and ( ASMETARES_ID <> 0 ) ) ) then
         begin
            i = 0;
            while ( i < PROCENT_CNT ) do
            begin
               if ( USE_BLOB <> 0 ) then
                  ID_PROCENT = readintfromblob ( PROCENT_ARR , i );

               /* from A_S_RES */
               if ( ( not ASMETARES_ID is null ) and ( ASMETARES_ID <> 0 ) ) then
               begin
                  ID_SOURCE = null;
                  select first 1 RASHOD , ID_SOURCE from a_s_res
                      where ( smetatype = :ID_PROCENT and NOMERROD = :ASMETARES_ID ) or
                            ( smetatype = :ID_PROCENT and ID = :ASMETARES_ID )
--                      where smetatype = :ID_PROCENT and NOMERROD = :ASMETARES_ID
                      into NORMARASH , ID_SOURCE;
                  if ( ID_SOURCE is null ) then
                  begin
                      RES_NOMERROD = null;
                      select first 1 NOMERROD from a_s_res
                      where ID = :ASMETARES_ID into RES_NOMERROD;

                      if ( ( not RES_NOMERROD is null ) and ( RES_NOMERROD <> 0 ) ) then
                         select first 1 RASHOD , ID_SOURCE from a_s_res
                            where ( smetatype = :ID_PROCENT and NOMERROD = :RES_NOMERROD ) or
                                  ( smetatype = :ID_PROCENT and ID = :RES_NOMERROD )
                         into NORMARASH , ID_SOURCE;
                  end
                  if ( not ID_SOURCE is null ) then
                     if ( ( not NORMARASH is null ) and ( not ID_SOURCE is null ) ) then
                        for select KOLL from a_smeta where ID = :ID_SOURCE into SM_KOLL
                        do
                        begin
                            IS_FOUND = IS_FOUND + 1;
                            if ( not SM_KOLL is null ) then
--                               KOLL = KOLL + NORMARASH; -- < 3.2
                               KOLL = KOLL + SM_KOLL * NORMARASH; -- 3.2
                        end
               end
               /* from A_SMETA */
               else if ( ( not ASMETA_ID is null ) and ( ASMETA_ID <> 0 ) ) then
               begin
                  SM_ID = null;
                  select first 1 KOLL, ID from a_smeta
                         where ( smetatype = :ID_PROCENT and NOMERROD1 = :ASMETA_ID ) or
                               ( smetatype = :ID_PROCENT and ID = :ASMETA_ID )
--                               where smetatype = :ID_PROCENT and NOMERROD = :ASMETA_ID
                      into SM_KOLL, SM_ID;
                  if ( SM_ID is null ) then
                  begin
                     NOMERROD1 = null;
                     select first 1 NOMERROD1
                     from a_smeta  where id = :SM_ID
                     into NOMERROD1;

                     if ( ( not NOMERROD1 is null ) and ( NOMERROD1 <> SM_ID ) ) then
                        select first 1 KOLL, ID from a_smeta
                            where ( smetatype = :ID_PROCENT and NOMERROD1 = :NOMERROD1 ) or
                                  ( smetatype = :ID_PROCENT and ID = :NOMERROD1 )
                      into SM_KOLL, SM_ID;
                  end
                  if ( not SM_ID is null ) then
                  begin
                     IS_FOUND = IS_FOUND + 1;
                     if ( not SM_KOLL is null ) then
                        KOLL = KOLL + SM_KOLL;
                  end
               end
               i = i + 1;
            end
         end

         if ( IS_FOUND > 0 ) then
            suspend;
      end
end
^


alter PROCEDURE A_S_GET_INDEX(
    IDUSER INTEGER,
    IDREC INTEGER,
    SLAVEPARENT INTEGER,
    ATYPE INTEGER,
    INDEX_ID_ORG INTEGER,
    INDEX_ID_GOD INTEGER,
    INDEX_ID_MES INTEGER,
    INDEX_NASNACHAUTO INTEGER,
    INDEX_ZAMENNASNACH INTEGER,
    INDEX_RASCHNRISP INTEGER,
    INDEX_BRAT_ZU_IS INTEGER,
    INDEX_UCHITNDS INTEGER,
    RES_COPY_INDEX INTEGER,
    MA DOUBLE PRECISION,
    MB DOUBLE PRECISION,
    MC DOUBLE PRECISION,
    MD DOUBLE PRECISION,
    ME DOUBLE PRECISION,
    MF DOUBLE PRECISION,
    MG DOUBLE PRECISION,
    MH DOUBLE PRECISION,
    MI DOUBLE PRECISION,
    PA DOUBLE PRECISION,
    PB DOUBLE PRECISION,
    PC DOUBLE PRECISION,
    PD DOUBLE PRECISION,
    PUNKTIND VARCHAR(42))
RETURNS (
    RES_MA DOUBLE PRECISION,
    RES_MB DOUBLE PRECISION,
    RES_MC DOUBLE PRECISION,
    RES_MD DOUBLE PRECISION,
    RES_ME DOUBLE PRECISION,
    RES_MF DOUBLE PRECISION,
    RES_MG DOUBLE PRECISION,
    RES_MH DOUBLE PRECISION,
    RES_MI DOUBLE PRECISION,
    RES_PA DOUBLE PRECISION,
    RES_PB DOUBLE PRECISION,
    RES_PC DOUBLE PRECISION,
    RES_PD DOUBLE PRECISION,
    RES_PUNKTIND VARCHAR(42),
    RES_DOSTUP INTEGER)
AS
DECLARE VARIABLE CUR_PA DOUBLE PRECISION;
DECLARE VARIABLE CUR_PB DOUBLE PRECISION;
DECLARE VARIABLE CUR_PC DOUBLE PRECISION;
DECLARE VARIABLE CUR_PD DOUBLE PRECISION;
DECLARE VARIABLE CUR_MF DOUBLE PRECISION;
DECLARE VARIABLE CUR_MG DOUBLE PRECISION;
DECLARE VARIABLE CUR_MH DOUBLE PRECISION;
DECLARE VARIABLE CUR_MI DOUBLE PRECISION;
DECLARE VARIABLE BANDS DOUBLE PRECISION;
DECLARE VARIABLE BENDS DOUBLE PRECISION;
DECLARE VARIABLE BCNDS DOUBLE PRECISION;
DECLARE VARIABLE BBNDS DOUBLE PRECISION;
DECLARE VARIABLE BDNDS DOUBLE PRECISION;
begin

 res_ma = ma;
 res_mb = mb;
 res_mc = mc;
 res_md = md;
 res_me = me;
 res_mf = mf;
 res_mg = mg;
 res_mh = mh;
 res_mi = mi;
 res_pa = pa;
 res_pb = pb;
 res_pc = pc;
 res_pd = pd;
 res_punktind = PUNKTIND;
 res_dostup = 1;

 if ( INDEX_NASNACHAUTO > 0 )
 then
 begin

  if (
      ( INDEX_ZAMENNASNACH > 0 ) or
      ( ( PUNKTIND is null ) or ( PUNKTIND = '' ) )
     )
  then
  begin

   if ( atype = 18 and RES_COPY_INDEX > 0 )
   then
   begin

    select s.ma, s.mb, s.mc, s.md, s.me, s.mf, s.mg, s.mh, s.mi, s.pa, s.pb, s.pc, s.pd, s.punktind
    from a_smeta s
    where s.id = :slaveparent
    into :res_ma, :res_mb, :res_mc, :res_md, :res_me, :cur_mf, :cur_mg, :cur_mh, :cur_mi, :cur_pa, :cur_pb, :cur_pc, :cur_pd, :res_punktind;

    if ( INDEX_RASCHNRISP = 1 )
    then
    begin

     res_mf = cur_mf;
     res_mg = cur_mg;

    end
    else
    begin

     res_pa = cur_pa;
     res_pb = cur_pb;

    end

    if ( INDEX_BRAT_ZU_IS = 0 )
    then
    begin

     res_mh = cur_mh;
     res_mi = cur_mi;

    end
    else
    begin

     res_pc = cur_pc;
     res_pd = cur_pd;

    end

   end
   else
   begin

    select i.ba, i.bb, i.bc, i.bd, i.be, i.pa, i.pb, i.zba, i.zbb, i.bands, i.bends, i.bcnds, i.bbnds, i.bdnds, i.dostup
    from B_READ_IND_RECORD_VALUES ( :IDUSER,
                                    :INDEX_ID_GOD,
                                    :INDEX_ID_MES,
                                    :INDEX_ID_ORG,
                                    :PUNKTIND, 0) i
    into :res_ma, :res_mb, :res_mc, :res_md, :res_me, :cur_pa, :cur_pb, :cur_pc, :cur_pd,
         :bands, :bends, :bcnds, :bbnds, :bdnds, :res_dostup;

    /*if ( res_me = 1 )
    then exception ae_a_s_synhron_slave_res_pe;*/


    if ( INDEX_UCHITNDS = 1 )
    then
    begin

     res_ma = bands;
     res_me = bends;
     res_mc = bcnds;
     res_mb = bbnds;
     res_md = bdnds;

    end

    if ( INDEX_RASCHNRISP = 1 )
    then
    begin

     res_mf = cur_pa;
     res_mg = cur_pb;

    end
    else
    begin

     res_pa = cur_pa;
     res_pb = cur_pb;

    end

    if ( INDEX_BRAT_ZU_IS = 0 )
    then
    begin

     res_mh = cur_pc;
     res_mi = cur_pd;

    end
    else
    begin
        /* MK    .       12.01.2005 -----> */
          if (atype = 18) then
          begin
            select s.pd
            from a_smeta s
            where s.id = :slaveparent
            into :cur_pd;
          end
        /* <----- MK*/

     res_pc = cur_pc;
     res_pd = cur_pd;

    end

   end


  end

 end

 if ( ( res_ma is null ) or ( res_ma = 0 ) ) then res_ma = 1;
 if ( ( res_mb is null ) or ( res_mb = 0 ) ) then res_mb = 1;
 if ( ( res_mc is null ) or ( res_mc = 0 ) ) then res_mc = 1;
 if ( ( res_md is null ) or ( res_md = 0 ) ) then res_md = 1;
 if ( ( res_me is null ) or ( res_me = 0 ) ) then res_me = 1;
 if ( res_mf is null ) then res_mf = 0;
 if ( res_mg is null ) then res_mg = 0;
 if ( ( res_mh is null ) or ( res_mh = 0 ) ) then res_mh = 1;
 if ( ( res_mi is null ) or ( res_mi = 0 ) ) then res_mi = 1;
 if ( res_pa is null ) then res_pa = 0;
 if ( res_pb is null ) then res_pb = 0;
 if ( ( res_pc is null ) or ( res_pc = 0 ) ) then res_pc = 1;
 if ( ( res_pd is null ) or ( res_pd = 0 ) ) then res_pd = 1;

 suspend;

end
^



alter PROCEDURE L_SELECT_RES_FOR_REPLACE(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER,
    NAME BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    EDIZM VARCHAR(255),
    ALTTAB VARCHAR(250),
    BA DOUBLE PRECISION,
    BB DOUBLE PRECISION,
    BC DOUBLE PRECISION,
    BD DOUBLE PRECISION,
    BE DOUBLE PRECISION,
    BF DOUBLE PRECISION,
    BG DOUBLE PRECISION,
    BH DOUBLE PRECISION,
    BI DOUBLE PRECISION,
    PA DOUBLE PRECISION,
    PB DOUBLE PRECISION,
    PC DOUBLE PRECISION,
    PD DOUBLE PRECISION,
    IDNORMATIVUNIQ INTEGER,
    KODIR_PODGROUP INTEGER,
    ISGROUPOKP INTEGER,
    TAB_OLD VARCHAR(42),
    RABMAT_OLD INTEGER,
    NAME_ID_OLD INTEGER,
    ID_EDIZM_OLD INTEGER,
    IDNORMATIV_OLD INTEGER,
    IS_CHECKED INTEGER,
    KP DOUBLE PRECISION,
    NORM_GUID VARCHAR(100),
    UCH INTEGER,
    VIDNR INTEGER,
    STATUS_DOB_V_ZENU INTEGER,
    NEEDUPDATENAME INTEGER,
    NEED_DEL INTEGER,
    CORRECT VARCHAR(50),
    TYPE_TRUD INTEGER)
AS
DECLARE VARIABLE ID INTEGER;
DECLARE VARIABLE ID_BLOB_GEN INTEGER;
begin
   exit;
end
^

ALTER PROCEDURE L_SELECT_SMETA_RES_NEW_GROUP_BY(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER)
AS
begin
   exit;
end
^

alter PROCEDURE L_SELECT_S_RES_NEW_GROUP_BY(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION)
AS
begin
   exit;
end
^


alter PROCEDURE L_SELECT_M29_RES_NEW_GROUP_BY(
    ID_M29 INTEGER,
    ID_OBJ INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    UNCHKLIST VARCHAR(30000),
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER)
AS
begin
   exit;
end
^


alter PROCEDURE L_REPL_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID1 INTEGER,
    REPLACE_CORRECT INTEGER,
    ID_USER INTEGER)
RETURNS (
    DELCOUNT INTEGER,
    REPLCOUNT INTEGER,
    SM_ID INTEGER,
    ID_SOURCE INTEGER,
    ID_SM_REC_CH_TRUD INTEGER,
    ID_SL_REC_CH_NR_AND_KOLL INTEGER,
    ID_RECALK_KOMPENS_ST INTEGER)
AS
begin
   exit;
end
^

alter PROCEDURE L_SELECT_SM_STRS_FOR_S_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    IN_S_RES_ID INTEGER,
    IN_S_RES_RABMAT INTEGER,
    IN_S_RES_IDNORMATIV INTEGER,
    IN_S_RES_TAB VARCHAR(42),
    IN_S_RES_NAME_ID INTEGER,
    IN_S_RES_ID_EDIZM INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    NUMBER1 INTEGER,
    NUMBER2 INTEGER,
    TAB VARCHAR(60),
    NAME_PART BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    NAME_TITLE BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    EDIZM VARCHAR(250),
    KOLL DOUBLE PRECISION,
    NORMARASH DOUBLE PRECISION)
AS
begin
   exit;
end
^


alter PROCEDURE L_SELECT_SM_STRS_ID_FOR_S_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    IN_S_RES_ID INTEGER,
    IN_S_RES_RABMAT INTEGER,
    IN_S_RES_IDNORMATIV INTEGER,
    IN_S_RES_TAB VARCHAR(42),
    IN_S_RES_NAME_ID INTEGER,
    IN_S_RES_ID_EDIZM INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER)
AS
begin
   exit;
end
^











alter PROCEDURE L_SELECT_RES_FOR_REPLACE(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER, 
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER,
    NAME BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    EDIZM VARCHAR(255),
    ALTTAB VARCHAR(250),
    BA DOUBLE PRECISION,
    BB DOUBLE PRECISION,
    BC DOUBLE PRECISION,
    BD DOUBLE PRECISION,
    BE DOUBLE PRECISION,
    BF DOUBLE PRECISION,
    BG DOUBLE PRECISION,
    BH DOUBLE PRECISION,
    BI DOUBLE PRECISION,
    PA DOUBLE PRECISION,
    PB DOUBLE PRECISION,
    PC DOUBLE PRECISION,
    PD DOUBLE PRECISION,
    IDNORMATIVUNIQ INTEGER,
    KODIR_PODGROUP INTEGER,
    ISGROUPOKP INTEGER,
    TAB_OLD VARCHAR(42),
    RABMAT_OLD INTEGER,
    NAME_ID_OLD INTEGER,
    ID_EDIZM_OLD INTEGER,
    IDNORMATIV_OLD INTEGER,
    IS_CHECKED INTEGER,
    KP DOUBLE PRECISION,
    NORM_GUID VARCHAR(100),
    UCH INTEGER,
    VIDNR INTEGER,
    STATUS_DOB_V_ZENU INTEGER,
    NEEDUPDATENAME INTEGER,
    NEED_DEL INTEGER,
    CORRECT VARCHAR(50),
    TYPE_TRUD INTEGER)
AS
DECLARE VARIABLE ID INTEGER;
DECLARE VARIABLE ID_BLOB_GEN INTEGER;
begin
   exit;
end
^

alter PROCEDURE L_SELECT_SMETA_RES_NEW_GROUP_BY(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER,
    STOIM DOUBLE PRECISION)
AS
begin
   exit;
end
^

alter PROCEDURE L_SELECT_SMETA_RES_NEW_GROUP_BY(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER,
    STOIM DOUBLE PRECISION)
AS
begin
   exit;
end
^


alter PROCEDURE L_SELECT_S_RES_NEW_GROUP_BY(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    STOIM DOUBLE PRECISION)
AS
begin
   exit;
end
^

alter PROCEDURE L_SELECT_M29_RES_NEW_GROUP_BY(
    ID_M29 INTEGER,
    ID_OBJ INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER, 
    UNCHKLIST VARCHAR(30000),
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER)
AS
begin
   exit;
end
^


alter PROCEDURE L_REPL_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER, 
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID1 INTEGER,
    REPLACE_CORRECT INTEGER,
    ID_USER INTEGER)
RETURNS (
    DELCOUNT INTEGER,
    REPLCOUNT INTEGER,
    SM_ID INTEGER,
    ID_SOURCE INTEGER,
    ID_SM_REC_CH_TRUD INTEGER,
    ID_SL_REC_CH_NR_AND_KOLL INTEGER,
    ID_RECALK_KOMPENS_ST INTEGER)
AS
begin
   exit;
end
^






alter PROCEDURE L_SELECT_RES_FOR_REPLACE(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER,
    NAME BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    EDIZM VARCHAR(255),
    ALTTAB VARCHAR(250),
    BA DOUBLE PRECISION,
    BB DOUBLE PRECISION,
    BC DOUBLE PRECISION,
    BD DOUBLE PRECISION,
    BE DOUBLE PRECISION,
    BF DOUBLE PRECISION,
    BG DOUBLE PRECISION,
    BH DOUBLE PRECISION,
    BI DOUBLE PRECISION,
    PA DOUBLE PRECISION,
    PB DOUBLE PRECISION,
    PC DOUBLE PRECISION,
    PD DOUBLE PRECISION,
    IDNORMATIVUNIQ INTEGER,
    KODIR_PODGROUP INTEGER,
    ISGROUPOKP INTEGER,
    TAB_OLD VARCHAR(42),
    RABMAT_OLD INTEGER,
    NAME_ID_OLD INTEGER,
    ID_EDIZM_OLD INTEGER,
    IDNORMATIV_OLD INTEGER,
    IS_CHECKED INTEGER,
    KP DOUBLE PRECISION,
    NORM_GUID VARCHAR(100),
    UCH INTEGER,
    VIDNR INTEGER,
    STATUS_DOB_V_ZENU INTEGER,
    NEEDUPDATENAME INTEGER,
    NEED_DEL INTEGER,
    CORRECT VARCHAR(50),
    TYPE_TRUD INTEGER,
    STOIM DOUBLE PRECISION,
    ID INTEGER,
    RAZRAD DOUBLE PRECISION)
AS
--DECLARE VARIABLE ID INTEGER;
DECLARE VARIABLE ID_BLOB_GEN INTEGER;
begin
/*
  SELECT_TYPE 0 , 1 - from smeta
                0 - from all visible hier ( use smetatype - type of smeta )
                1 - from selected strings ( use memo , smetatype - as cnt )
              2 , 3 - from m29
                2 - from all visible hier ( use UNCHKLIST , smetatype - id_m29 )
                3 - from selected strings ( use memo , smetatype - as cnt )
              4 , 5 - Smetn. Res.
*/

   TYPE_TRUD = null;

   if ( MEMO is null ) then
      CNT = 0;

   if ( not MEMO is null ) then
   begin
       /* clear blob */
       ID_BLOB_GEN = GEN_ID(B_GEN_TEMP, 1);
       INSERT INTO B_TEMP_BLOB(ID, BLOB1) VALUES (:ID_BLOB_GEN, :MEMO);
       SELECT BLOB1 FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN INTO :MEMO;
       DELETE FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN;
   end

   if ( SELECT_TYPE in ( 0 , 1 ) ) then /* from smeta */
      FOR SELECT ID, RABMAT, IDNORMATIV, TAB, NAME_ID, ID_EDIZM, SUM_ID, OFFSET
          FROM L_SELECT_SMETA_RES_NEW_GROUP_BY (
                :ID_OBJ, :SMETATYPE, :SELECT_TYPE, :MEMO, :CNT, :IN_KODIR_GROUP, :IN_KODIR_PODGROUP, :ID_USER )
          INTO ID, RABMAT, IDNORMATIV, TAB, NAME_ID, ID_EDIZM, SUM_ID, OFFSET
      do
      begin
         execute procedure b_getname ( :ID_USER , :name_id ) returning_values ( :name );
         execute procedure a_get_edizm ( :ID_USER , :id_edizm , 0 ) returning_values ( :edizm );

         for select alttab , ba , bb , bc , bd , be , bf , bg , bh , bi , pa , pb , pc , pd , IDNORMATIVUNIQ , KODIR_PODGROUP , ISGROUPOKP
                    , NORM_GUID
             from a_smeta where id = :id
             into   alttab , ba , bb , bc , bd , be , bf , bg , bh , bi , pa , pb , pc , pd , IDNORMATIVUNIQ , KODIR_PODGROUP , ISGROUPOKP
                    , NORM_GUID
         do
         begin
            TAB_OLD = TAB;
            RABMAT_OLD = RABMAT;
            NAME_ID_OLD =  NAME_ID;
            ID_EDIZM_OLD = ID_EDIZM;
            IDNORMATIV_OLD = IDNORMATIV;
            IS_CHECKED = 0;
            KP = 1;
            NEED_DEL = 0;
            NEEDUPDATENAME = 0;
            CORRECT = NULL;

            suspend; 
         end
      end
   else if ( SELECT_TYPE in ( 2 , 3 ) ) then  /* from m29 */
   begin
      BD = 0;
      BE = 0;
      BF = 0;
      BG = 0;
      BH = 0;
      BI = 0;
      PA = 0;
      PB = 0;
      PC = 0;
      PD = 0;
      FOR SELECT ID, RABMAT, IDNORMATIV, TAB, NAME_ID, ID_EDIZM, SUM_ID, OFFSET
          FROM L_SELECT_M29_RES_NEW_GROUP_BY (
                :SMETATYPE, :ID_OBJ, :SELECT_TYPE, :MEMO, :CNT, :UNCHKLIST, :ID_USER )
          INTO ID, RABMAT, IDNORMATIV, TAB, NAME_ID, ID_EDIZM, SUM_ID, OFFSET
      do
      begin
         execute procedure a_get_edizm ( :ID_USER , :id_edizm , 0 ) returning_values ( :edizm );

         for select name , alttab , csmetn , IDNORMATIVUNIQ , KODIR_PODGROUP , ISGROUPOKP, NORM_GUID
             from l_m29 where id_self = :id
             into   name , alttab , ba , IDNORMATIVUNIQ , KODIR_PODGROUP , ISGROUPOKP, NORM_GUID
         do
         begin
            TAB_OLD = TAB;
            RABMAT_OLD = RABMAT;
            NAME_ID_OLD =  NAME_ID;
            ID_EDIZM_OLD = ID_EDIZM;
            IDNORMATIV_OLD = IDNORMATIV;
            IS_CHECKED = 0;
            KP = 1;
            NEED_DEL = 0;
            NEEDUPDATENAME = 0;
            CORRECT = NULL;

            BB = 0;
            BC = 0;
            for select CCURRENT , CCURRENT_ZONE from l_m29_spis
                where ID_M29 = :SMETATYPE and ID_SPIS = 0  and ID_REC = :ID
                into BB, BC
            do
                BB = BB;

            suspend; 
         end
      end
   end
   else if ( SELECT_TYPE in ( 4 , 5 ) ) then  /* from a_s_res */
   begin
      FOR SELECT ID, RABMAT, IDNORMATIV, TAB, NAME_ID, ID_EDIZM, SUM_ID, OFFSET,
                 STOIM
          FROM L_SELECT_SMETA_RES_NEW_GROUP_BY (
                :ID_OBJ, :SMETATYPE, :SELECT_TYPE, :MEMO, :CNT, :IN_KODIR_GROUP, :IN_KODIR_PODGROUP, :ID_USER )
          INTO ID, RABMAT, IDNORMATIV, TAB, NAME_ID, ID_EDIZM, SUM_ID, OFFSET,
               STOIM
      do
      begin
         execute procedure b_getname ( :ID_USER , :name_id ) returning_values ( :name );
         execute procedure a_get_edizm ( :ID_USER , :id_edizm , 0 ) returning_values ( :edizm );

         for select bb , bc , bd , be , /*IDNORMATIVUNIQ ,*/ NORM_PODGROUP , ISGROUPOKP
                    , NORM_GUID , UCH , VIDNR , STATUS_DOB_V_ZENU , TYPE_TRUD
             from a_s_res where id = :id
             into   bb , bc , bd , be , /*IDNORMATIVUNIQ ,*/ KODIR_PODGROUP , ISGROUPOKP
                    , NORM_GUID , UCH , VIDNR , STATUS_DOB_V_ZENU , TYPE_TRUD
         do
         begin
            BA = BB + BC + BE;
            TAB_OLD = TAB;
            RABMAT_OLD = RABMAT;
            NAME_ID_OLD =  NAME_ID;
            ID_EDIZM_OLD = ID_EDIZM;
            IDNORMATIV_OLD = IDNORMATIV;
            IS_CHECKED = 0;
            KP = 1;
            IDNORMATIVUNIQ = 0;
            NEED_DEL = 0;
            NEEDUPDATENAME = 0;
            CORRECT = NULL;

            suspend; 
         end
      end
   end
end
^


alter PROCEDURE L_SELECT_SMETA_RES_NEW_GROUP_BY(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER,
    STOIM DOUBLE PRECISION)
AS
DECLARE VARIABLE ID_BLOB_GEN INTEGER;
DECLARE VARIABLE s_id INTEGER;
declare variable LC_ATYPE INTEGER;
begin
/*
  SELECT_TYPE 0 - from smetatype
              1 - from memo , smetatype - cnt
              4 - from a_s_res for smetatype
              5 - from a_s_res from memo , smetatype - cnt
*/
   STOIM=0.0;
   if ( not MEMO is null ) then
   begin
       /* clear blob */
       ID_BLOB_GEN = GEN_ID(B_GEN_TEMP, 1);
       INSERT INTO B_TEMP_BLOB(ID, BLOB1) VALUES (:ID_BLOB_GEN, :MEMO);
       SELECT BLOB1 FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN INTO :MEMO;
       DELETE FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN;
   end


   OFFSET = GEN_ID ( LG_START_SMETA , 0 );

   if ( SMETATYPE = 16 ) then
      LC_ATYPE = 16;
   else
      LC_ATYPE = 15;

   if ( SELECT_TYPE = 0 ) then
      FOR SELECT min(id), rabmat, min(idnormativ), TAB, name_id, id_edizm, sum(id-:OFFSET)
          FROM A_SMETA A
          WHERE A.IDHIER IN ( SELECT IDNODE
                               FROM A_H_HIERLOADCHECKED ( :ID_USER, :ID_OBJ, :SMETATYPE, :LC_ATYPE )
                             )
                AND A.SMETATYPE = :SMETATYPE /*AND A.ATYPE = 18 */
                AND A.rabmat <> 0

          GROUP BY rabmat , /*A.idnormativ ,*/ tab , name_id , id_edizm
          order by rabmat , tab
          INTO   id, rabmat, idnormativ, TAB, name_id, id_edizm, SUM_ID
      do
         suspend;
   else if ( SELECT_TYPE = 1 ) then
      FOR SELECT min(id), rabmat, min(idnormativ), TAB, name_id, id_edizm, sum(id-:OFFSET)
          FROM A_SMETA A
          WHERE A.ID IN ( SELECT FVALUE
                          FROM S_INTFROMBLOB_SELECT ( :MEMO, :CNT )
                        )
          GROUP BY rabmat , /*A.idnormativ ,*/ tab , name_id , id_edizm
          order by rabmat , tab
          INTO   id, rabmat, idnormativ, TAB, name_id, id_edizm, SUM_ID
      do
         suspend;
   else if ( SELECT_TYPE in ( 4 , 5 ) ) then
         for select min(id), rabmat, min(IDNORMATIV), TAB, name_id, id_edizm, sum(id-:OFFSET),
                    sum(STOIM)
             FROM L_SELECT_S_RES_NEW_GROUP_BY( :ID_OBJ , :SMETATYPE , :SELECT_TYPE , :MEMO , :CNT, :IN_KODIR_GROUP, :IN_KODIR_PODGROUP , :ID_USER )
             GROUP BY rabmat , /*IDNORMATIV ,*/ tab , name_id , id_edizm
             order by rabmat , tab
             INTO   id, rabmat, idnormativ, TAB, name_id, id_edizm, SUM_ID,
                    :STOIM
         do
             suspend;
end
^


alter PROCEDURE L_SELECT_S_RES_NEW_GROUP_BY(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    STOIM DOUBLE PRECISION)
AS
DECLARE VARIABLE s_id INTEGER;
DECLARE VARIABLE idhier INTEGER;
declare variable LC_ATYPE INTEGER;
declare variable ASMETATYPE INTEGER;
begin
   if ( SMETATYPE = 16 ) then
   begin
      LC_ATYPE = 16;
      ASMETATYPE = -ID_OBJ;
   end
   else if ( SMETATYPE = 15 ) then
   begin
      LC_ATYPE = 15;
      ASMETATYPE = ID_OBJ;
   end
   else
   begin
      LC_ATYPE = 15;
      ASMETATYPE = SMETATYPE;
   end

   if ( SELECT_TYPE = 4 ) then
/*
      FOR SELECT id from a_smeta a
          WHERE A.IDHIER IN ( SELECT IDNODE
                               FROM A_H_HIERLOADCHECKED ( :ID_USER, :ID_OBJ, :SMETATYPE, :LC_ATYPE )
                             )
                AND A.SMETATYPE = :SMETATYPE AND A.ATYPE = 17
          into s_id
      do
         for select id, rabmat, NORM_ID, TAB, name_id, idedizm
             FROM a_s_res_select ( :ID_USER , :s_id , :IN_KODIR_GROUP , :IN_KODIR_PODGROUP, 0 ) S
             INTO   id, rabmat, idnormativ, TAB, name_id, id_edizm
         do
             suspend;
*/
      FOR SELECT IDNODE
          FROM A_H_HIERLOADCHECKED ( :ID_USER, :ID_OBJ, :SMETATYPE, :LC_ATYPE )
          into idhier
      do
         for select id, rabmat, NORM_ID, TAB, name_id, idedizm,
             (RASHOD * (BB+BC+BE))
             from a_s_res r
             where r.smetatype = :ASMETATYPE and
                   r.idhier = :idhier and
                   r.kodir_group = :IN_KODIR_GROUP and
                   r.kodir_podgroup = :IN_KODIR_PODGROUP
             INTO   id, rabmat, idnormativ, TAB, name_id, id_edizm,
                    :STOIM
         do
             suspend;
   else if ( SELECT_TYPE = 5 ) then
      FOR SELECT FVALUE
          FROM S_INTFROMBLOB_SELECT ( :MEMO, :CNT )
          into s_id
      do
         for select id, rabmat, NORM_ID, TAB, name_id, idedizm,
             (RASHOD * (BB+BC+BE))
             FROM a_s_res_select ( :ID_USER , :s_id , :IN_KODIR_GROUP , :IN_KODIR_PODGROUP, 0 ) S
             INTO   id, rabmat, idnormativ, TAB, name_id, id_edizm,
                    :STOIM
         do
             suspend;
END
^



alter PROCEDURE L_SELECT_M29_RES_NEW_GROUP_BY(
    ID_M29 INTEGER,
    ID_OBJ INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    UNCHKLIST VARCHAR(30000),
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    RABMAT INTEGER,
    IDNORMATIV INTEGER,
    TAB VARCHAR(42),
    NAME_ID INTEGER,
    ID_EDIZM INTEGER,
    SUM_ID DOUBLE PRECISION,
    OFFSET INTEGER)
AS
DECLARE VARIABLE ID_BLOB_GEN INTEGER;
begin
/*
  SELECT_TYPE   2 - from all visible hier ( use UNCHKLIST )
                3 - from selected strings ( use memo , ID_OBJ - as cnt )
*/

   if ( not MEMO is null ) then
   begin
       /* clear blob */
       ID_BLOB_GEN = GEN_ID(B_GEN_TEMP, 1);
       INSERT INTO B_TEMP_BLOB(ID, BLOB1) VALUES (:ID_BLOB_GEN, :MEMO);
       SELECT BLOB1 FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN INTO :MEMO;
       DELETE FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN;
   end

   name_id = 0;
   offset = 0;

   if ( SELECT_TYPE = 2 ) then
      FOR SELECT min(id_self), rabmat, min(idnormativ), TAB, id_edizm, sum(id_self)
          FROM L_M29 M
          WHERE M.IDHIER IN ( SELECT IDHIER
                               FROM L_M29_SELECT_VISIBLE_HIER  ( :ID_OBJ, :UNCHKLIST )
                             )
                AND M.ID_M29 = :ID_M29 AND M.NUMBER3 = 0 and
                ( M.NUMBER2 <> 0 or M.RABMAT <> 0 )
          GROUP BY rabmat , /*idnormativ ,*/ tab , id_edizm
          order by rabmat , tab
          INTO   id, rabmat, idnormativ, TAB, id_edizm, SUM_ID
      do
         suspend;
   else if ( SELECT_TYPE = 3 ) then
      FOR SELECT min(id_self), rabmat, min(idnormativ), TAB, id_edizm, sum(id_self)
          FROM L_M29 M
          WHERE M.ID_SELF IN ( SELECT FVALUE
                          FROM S_INTFROMBLOB_SELECT ( :MEMO, :CNT )
                        )
          GROUP BY rabmat , /*idnormativ ,*/ tab , id_edizm
          order by rabmat , tab
          INTO   id, rabmat, idnormativ, TAB, id_edizm, SUM_ID
      do
         suspend;
end
^


alter PROCEDURE L_REPL_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER, 
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    ID1 INTEGER,
    REPLACE_CORRECT INTEGER,
    ID_USER INTEGER)
RETURNS (
    DELCOUNT INTEGER,
    REPLCOUNT INTEGER,
    SM_ID INTEGER,
    ID_SOURCE INTEGER,
    ID_SM_REC_CH_TRUD INTEGER,
    ID_SL_REC_CH_NR_AND_KOLL INTEGER,
    ID_RECALK_KOMPENS_ST INTEGER)
AS
DECLARE VARIABLE S_RES_ID INTEGER;
DECLARE VARIABLE S_RES_RABMAT INTEGER;
DECLARE VARIABLE S_RES_IDNORMATIV INTEGER;
DECLARE VARIABLE S_RES_TAB VARCHAR(42);
DECLARE VARIABLE S_RES_NAME_ID INTEGER;
DECLARE VARIABLE S_RES_ID_EDIZM INTEGER;
DECLARE VARIABLE RABMAT INTEGER;
DECLARE VARIABLE IDNORMATIV INTEGER;
DECLARE VARIABLE TAB VARCHAR(60);
DECLARE VARIABLE NAME_ID INTEGER;
DECLARE VARIABLE ID_EDIZM INTEGER;
DECLARE VARIABLE SUM_ID DOUBLE PRECISION;
DECLARE VARIABLE OFFSET INTEGER;
DECLARE VARIABLE NAME BLOB SUB_TYPE 0 SEGMENT SIZE 80;
DECLARE VARIABLE EDIZM VARCHAR(255);
DECLARE VARIABLE ALTTAB VARCHAR(250);
DECLARE VARIABLE BA DOUBLE PRECISION;
DECLARE VARIABLE BB DOUBLE PRECISION;
DECLARE VARIABLE BC DOUBLE PRECISION;
DECLARE VARIABLE BD DOUBLE PRECISION;
DECLARE VARIABLE BE DOUBLE PRECISION;
DECLARE VARIABLE BF DOUBLE PRECISION;
DECLARE VARIABLE BG DOUBLE PRECISION;
DECLARE VARIABLE BH DOUBLE PRECISION;
DECLARE VARIABLE BI DOUBLE PRECISION;
DECLARE VARIABLE PA DOUBLE PRECISION;
DECLARE VARIABLE PB DOUBLE PRECISION;
DECLARE VARIABLE PC DOUBLE PRECISION;
DECLARE VARIABLE PD DOUBLE PRECISION;
DECLARE VARIABLE IDNORMATIVUNIQ INTEGER;
DECLARE VARIABLE KODIR_PODGROUP INTEGER;
DECLARE VARIABLE ISGROUPOKP INTEGER;
DECLARE VARIABLE TAB_OLD VARCHAR(42);
DECLARE VARIABLE RABMAT_OLD INTEGER;
DECLARE VARIABLE NAME_ID_OLD INTEGER;
DECLARE VARIABLE ID_EDIZM_OLD INTEGER;
DECLARE VARIABLE IDNORMATIV_OLD INTEGER;
DECLARE VARIABLE IS_CHECKED INTEGER;
DECLARE VARIABLE KP DOUBLE PRECISION;
DECLARE VARIABLE NORM_GUID VARCHAR(100);
DECLARE VARIABLE UCH INTEGER;
DECLARE VARIABLE VIDNR INTEGER;
DECLARE VARIABLE STATUS_DOB_V_ZENU INTEGER;
DECLARE VARIABLE NEEDUPDATENAME INTEGER;
DECLARE VARIABLE NEED_DEL INTEGER;
DECLARE VARIABLE S_RES_ID_SOURCE INTEGER;
DECLARE VARIABLE S_RES_KODIR_GROUP INTEGER;
DECLARE VARIABLE S_RES_KODIR_PODGROUP INTEGER;
DECLARE VARIABLE S_RES_EDIZM_TYPE INTEGER;
DECLARE VARIABLE S_RES_RASHOD DOUBLE PRECISION;
DECLARE VARIABLE S_RES_STATUS_EDIT INTEGER;
DECLARE VARIABLE S_RES_STATUS_REC_CEN INTEGER;
DECLARE VARIABLE S_RES_NOTE VARCHAR(255);
DECLARE VARIABLE S_RES_NORM_ID INTEGER;
DECLARE VARIABLE S_RES_NORM_PODGROUP INTEGER;
DECLARE VARIABLE S_RES_ISGROUPOKP INTEGER;
DECLARE VARIABLE S_RES_ALTTAB VARCHAR(250);
DECLARE VARIABLE S_RES_IDEDIZM INTEGER;
DECLARE VARIABLE S_RES_BB DOUBLE PRECISION;
DECLARE VARIABLE S_RES_BC DOUBLE PRECISION;
DECLARE VARIABLE S_RES_BD DOUBLE PRECISION;
DECLARE VARIABLE S_RES_BE DOUBLE PRECISION;
DECLARE VARIABLE S_RES_VIDNR INTEGER;
DECLARE VARIABLE S_RES_UCH INTEGER;
DECLARE VARIABLE S_RES_NORM_GUID VARCHAR(100);
DECLARE VARIABLE S_RES_RABMAT_OLD INTEGER;
DECLARE VARIABLE COMPARE_IDNORMATIV INTEGER;
DECLARE VARIABLE COMPARE_NAME_ID INTEGER;
DECLARE VARIABLE COMPARE_ID_EDIZM INTEGER;
DECLARE VARIABLE ID_ZONE INTEGER;
DECLARE VARIABLE SAVECENZONETONORMBASE INTEGER;
DECLARE VARIABLE RESULT INTEGER;
DECLARE VARIABLE STATUS_REC_CEN INTEGER;
DECLARE VARIABLE RES_RASHOD_BASE DOUBLE PRECISION;
DECLARE VARIABLE RES_CORRECT VARCHAR(50);
DECLARE VARIABLE NEED_REFRESH_SM_STR INTEGER;
DECLARE VARIABLE TYPE_TRUD INTEGER;
DECLARE VARIABLE TYPE_TRUD_OLD INTEGER;
DECLARE VARIABLE CORRECT VARCHAR(50);
DECLARE VARIABLE NEW_CORRECT VARCHAR(50);
DECLARE VARIABLE RES_CNT INTEGER;
DECLARE VARIABLE ISCLC INTEGER;
DECLARE VARIABLE CLC INTEGER;
DECLARE VARIABLE CLCMODE INTEGER;
declare variable mode_kompns_st integer;
declare variable res_uch integer;
begin

 if ( smetatype > 16 )
 then select p.isclc
      from l_h_getobject_procent_param( :id_user, :smetatype ) p
      into :isclc;
 else select p.isclc
      from a_s_get_params_obj( :id_user, :id_obj ) p
      into :isclc;

 execute procedure a_clc_get_mode( :id_user, :isclc )
         returning_values( :clc, :clcmode );


 mode_kompns_st = 0;

 select mode_kompns_st, id_zone, savecenzonetonormbase
 from a_get_params_obj_akt( :id_user, :id_obj, :smetatype )
 into :mode_kompns_st, :id_zone, :savecenzonetonormbase;

 mode_kompns_st = getbit( mode_kompns_st, 0 );


   DELCOUNT  = 0;
   REPLCOUNT = 0;
   ID_SM_REC_CH_TRUD = null;
   ID_SL_REC_CH_NR_AND_KOLL = null;
   if ( SELECT_TYPE in ( 4 , 5 ) ) then
   begin

      if ( savecenzonetonormbase is null ) then
         savecenzonetonormbase = 0;
      if ( (id_zone is null) or (savecenzonetonormbase=0) ) then
         id_zone = 0;

      if ( REPLACE_CORRECT is null ) then
         REPLACE_CORRECT = 0;

      for select id, rabmat, IDNORMATIV, TAB, name_id, id_edizm
          FROM L_SELECT_S_RES_NEW_GROUP_BY( :ID_OBJ , :SMETATYPE , :SELECT_TYPE , :MEMO , :CNT, :IN_KODIR_GROUP, :IN_KODIR_PODGROUP , :ID_USER )
          INTO   S_RES_id, S_RES_rabmat, S_RES_idnormativ, S_RES_TAB, S_RES_name_id, S_RES_id_edizm
      do
         for select rabmat, idnormativ, tab, name_id, id_edizm, sum_id, offset,
                    name, edizm, alttab, ba, bb, bc, bd, be, bf, bg, bh, bi, pa, pb, pc, pd,
                    idnormativuniq, kodir_podgroup, isgroupokp, tab_old, rabmat_old, name_id_old,
                    id_edizm_old, idnormativ_old, is_checked, kp, norm_guid, uch, vidnr,
                    status_dob_v_zenu, NEEDUPDATENAME, need_del, type_trud, correct
             from l_repl_res_tbl where ID1 = :ID1
             into   rabmat, idnormativ, tab, name_id, id_edizm, sum_id, offset,
                    name, edizm, alttab, ba, bb, bc, bd, be, bf, bg, bh, bi, pa, pb, pc, pd,
                    idnormativuniq, kodir_podgroup, isgroupokp, tab_old, rabmat_old, name_id_old,
                    id_edizm_old, idnormativ_old, is_checked, kp, norm_guid, uch, vidnr,
                    status_dob_v_zenu, NEEDUPDATENAME, need_del, type_trud, correct
         do
         begin
            need_refresh_sm_str = 0;

--            execute procedure a_compare_integer( :IDNORMATIV_old , :S_RES_idnormativ )
--                    returning_values( :compare_idnormativ );
            execute procedure a_compare_integer( :name_id_old , :S_RES_name_id )
                    returning_values( :compare_name_id );
            execute procedure a_compare_integer( :id_edizm_old , :S_RES_id_edizm )
                    returning_values( :compare_id_edizm );

            if ( ( rabmat_old = S_RES_rabmat ) and /* ( compare_idnormativ = 1 ) and */
                 ( tab_old = S_RES_tab ) and ( compare_name_id = 1 ) and ( compare_id_edizm = 1 ) ) then
            begin
               SM_ID = null;
               ID_SOURCE = null;
               ID_RECALK_KOMPENS_ST = null;

               if ( ( rabmat = 1 ) and ( type_trud in ( 1, 2 ) ) ) then
                  need_refresh_sm_str = 1;

               if ( need_del = 1 ) then
               begin
                  select first 1 ID from a_smeta where ID_S_RES = :S_RES_id into SM_ID;


                  if ( need_refresh_sm_str <> 0 )
                  then select first 1 ID_SOURCE
                       from a_s_res v where v.id = :S_RES_id
                       into :ID_SOURCE;

                  if ( mode_kompns_st  = 1 )
                  then
                  begin

                   select first 1 ID_SOURCE, v.uch
                   from a_s_res v where v.id = :S_RES_id
                   into :ID_RECALK_KOMPENS_ST, :res_uch;

                   if ( res_uch <> 1 )
                   then ID_RECALK_KOMPENS_ST = null;

                  end

                  delete from a_s_res v where v.id = :S_RES_id;

                  DELCOUNT = DELCOUNT + 1;
                  suspend;
               end
               else if ( is_checked = 1 ) then
               begin

                  for select first 1 ID_SOURCE , KODIR_GROUP , KODIR_PODGROUP , EDIZM_TYPE , RASHOD ,
                                     STATUS_EDIT , STATUS_REC_CEN , NOTE,
                                     NORM_ID, NORM_PODGROUP, ISGROUPOKP, ALTTAB,
                                     IDEDIZM, BB, BC, BD, BE, VIDNR, UCH, NORM_GUID, type_trud, rabmat,
                                     rashod_base, correct
                      from a_s_res
                      where ID = :S_RES_id
                      into S_RES_ID_SOURCE , S_RES_KODIR_GROUP , S_RES_KODIR_PODGROUP , S_RES_EDIZM_TYPE , S_RES_RASHOD ,
                           S_RES_STATUS_EDIT , S_RES_STATUS_REC_CEN , S_RES_NOTE,
                           S_RES_NORM_ID, S_RES_NORM_PODGROUP, S_RES_ISGROUPOKP, S_RES_ALTTAB,
                           S_RES_IDEDIZM, S_RES_BB, S_RES_BC, S_RES_BD, S_RES_BE,
                           S_RES_VIDNR, S_RES_UCH, S_RES_NORM_GUID, type_trud_old, S_RES_rabmat_old,
                           res_rashod_base, res_correct
                  do
                     if ( ( S_RES_rabmat_old = 1 ) and ( type_trud_old in ( 1, 2 ) ) ) then
                         need_refresh_sm_str = 1;

                  if ( S_RES_STATUS_EDIT = 0 ) then
                  begin
                     if ( ( NEEDUPDATENAME <> 0 ) or
                          /*( IDNORMATIV <> S_RES_NORM_ID ) or */ ( kodir_podgroup <> S_RES_NORM_PODGROUP ) or ( ISGROUPOKP <> S_RES_ISGROUPOKP ) or
                          ( RABMAT <> S_RES_RABMAT ) or ( TAB <> S_RES_TAB ) or
                          ( ALTTAB <> S_RES_ALTTAB ) or ( ID_EDIZM <> S_RES_IDEDIZM ) or ( BB <> S_RES_BB ) or
                          ( BC <> S_RES_BC ) or ( BD <> S_RES_BD ) or ( BE <> S_RES_BE ) or
                          ( VIDNR <> S_RES_VIDNR ) or ( UCH <> S_RES_UCH ) or ( NORM_GUID <> S_RES_NORM_GUID ) ) then
                        S_RES_STATUS_EDIT = 1;
                  end


                  execute procedure a_s_res_update ( :ID_USER, :S_RES_id, :S_RES_ID_SOURCE , :idnormativ,
                     :kodir_podgroup, :S_RES_KODIR_GROUP, :S_RES_KODIR_PODGROUP, :ISGROUPOKP, :RABMAT,
                     :TAB, :ALTTAB, :NAME, :NAME_ID, :ID_EDIZM, :S_RES_EDIZM_TYPE, :S_RES_RASHOD,
                     :res_rashod_base, :res_correct,
                     :BB, :BC, :BD, :BE, :VIDNR, :UCH, :S_RES_STATUS_EDIT, :STATUS_DOB_V_ZENU,
                     /*:S_RES_STATUS_REC_CEN*/null, :S_RES_NOTE, :NEEDUPDATENAME, :NORM_GUID,
                     :type_trud);

                  res_cnt = 0;
                  ID_SM_REC_CH_TRUD = null;
                  ID_SL_REC_CH_NR_AND_KOLL = null;
                  for select ID_SM_REC_CH_TRUD, ID_SL_REC_CH_NR_AND_KOLL
                      from A_S_RES_APPLAY_CORRECTION_1 (
                          :ID_USER, :RABMAT, :type_trud, '%', :correct, :REPLACE_CORRECT, :S_RES_id )
                      into   ID_SM_REC_CH_TRUD, ID_SL_REC_CH_NR_AND_KOLL
                  do
                  begin
                      res_cnt = res_cnt + 1;
                      suspend;

                  end
                  ID_SM_REC_CH_TRUD = null;
                  ID_SL_REC_CH_NR_AND_KOLL = null;
/*
                  if ( res_cnt > 0 ) then
                      select first 1 RASHOD, rashod_base, correct
                      from a_s_res
                      where ID = :S_RES_id
                      into  S_RES_RASHOD, res_rashod_base, res_correct;
*/

                  if (id_zone <> 0) then
                     execute procedure l_s_save_ccurrent_to_normy(:ID_USER, :ID_ZONE, :S_RES_NORM_ID, :S_RES_rabmat, :S_RES_NORM_PODGROUP,
                            :BA, :BB, :BC, :BD, :BE, :S_RES_id, 1)
                         returning_values ( :RESULT, :STATUS_REC_CEN );


                  ID_SOURCE = null;
                  if ( ( need_refresh_sm_str <> 0 ) or ( clc = 1 ) ) then
                     ID_SOURCE = S_RES_ID_SOURCE;


                  ID_RECALK_KOMPENS_ST = null;
                  if ( mode_kompns_st  = 1 )
                  then
                  begin

                   if (
                       ( s_res_uch = 1 ) or
                       ( uch = 1 )
                      )
                   then ID_RECALK_KOMPENS_ST = S_RES_ID_SOURCE;

                  end


                  REPLCOUNT = REPLCOUNT + 1;
                  suspend;
               end

            end
         end
   end

end
^


alter PROCEDURE L_SELECT_SM_STRS_FOR_S_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER, 
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    IN_S_RES_ID INTEGER,
    IN_S_RES_RABMAT INTEGER,
    IN_S_RES_IDNORMATIV INTEGER,
    IN_S_RES_TAB VARCHAR(42),
    IN_S_RES_NAME_ID INTEGER,
    IN_S_RES_ID_EDIZM INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    NUMBER1 INTEGER,
    NUMBER2 INTEGER,
    TAB VARCHAR(60),
    NAME_PART BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    NAME_TITLE BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    EDIZM VARCHAR(250),
    KOLL DOUBLE PRECISION,
    NORMARASH DOUBLE PRECISION)
AS
begin
   exit;
end
^


alter PROCEDURE L_SELECT_SM_STRS_ID_FOR_S_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER, 
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    IN_S_RES_ID INTEGER,
    IN_S_RES_RABMAT INTEGER,
    IN_S_RES_IDNORMATIV INTEGER,
    IN_S_RES_TAB VARCHAR(42),
    IN_S_RES_NAME_ID INTEGER,
    IN_S_RES_ID_EDIZM INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER)
AS
begin
   exit;
end
^


alter PROCEDURE L_SELECT_SM_STRS_FOR_S_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    IN_S_RES_ID INTEGER,
    IN_S_RES_RABMAT INTEGER,
    IN_S_RES_IDNORMATIV INTEGER,
    IN_S_RES_TAB VARCHAR(42),
    IN_S_RES_NAME_ID INTEGER,
    IN_S_RES_ID_EDIZM INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER,
    NUMBER1 INTEGER,
    NUMBER2 INTEGER,
    TAB VARCHAR(60),
    NAME_PART BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    NAME_TITLE BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    EDIZM VARCHAR(250),
    KOLL DOUBLE PRECISION,
    NORMARASH DOUBLE PRECISION)
AS
declare variable NAME_ID integer;
declare variable ID_EDIZM integer;
declare variable ID_BLOB_GEN integer;
begin

   if ( not MEMO is null ) then
   begin
       /* clear blob */
       ID_BLOB_GEN = GEN_ID(B_GEN_TEMP, 1);
       INSERT INTO B_TEMP_BLOB(ID, BLOB1) VALUES (:ID_BLOB_GEN, :MEMO);
       SELECT BLOB1 FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN INTO :MEMO;
       DELETE FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN;
   end

   if ( SELECT_TYPE in ( 0 , 1 , 4 , 5 ) ) then
      for select ID
          from L_SELECT_SM_STRS_ID_FOR_S_RES( :ID_OBJ, :SMETATYPE, :SELECT_TYPE, :MEMO, :CNT, :UNCHKLIST,
                :IN_KODIR_GROUP, :IN_KODIR_PODGROUP, :IN_S_RES_ID, :IN_S_RES_RABMAT,
                :IN_S_RES_IDNORMATIV, :IN_S_RES_TAB, :IN_S_RES_NAME_ID, :IN_S_RES_ID_EDIZM, :ID_USER )
          into ID
      do
         for select first 1 NUMBER1, NUMBER2, TAB, NAME_ID, ID_EDIZM, KOLL, NORMARASH
             from a_smeta where ID = :ID
             into NUMBER1, NUMBER2, TAB, NAME_ID, ID_EDIZM, KOLL, NORMARASH
         do
         begin
            NAME_TITLE = null;
            NAME_PART = null;
            for select first 1 NAME_TITLE , NAME_PART
                from B_GETNAME_2 ( :ID_USER , :NAME_ID )
                into NAME_TITLE , NAME_PART
            do
               ID = ID;

            EDIZM = null;
            for select first 1 EDIZMNAME
                from B_GET_EDIZM ( :ID_EDIZM )
                into EDIZM
            do
               ID = ID;

            suspend;
         end
   else if ( SELECT_TYPE in ( 2 , 3 ) ) then
      for select ID
          from L_SELECT_SM_STRS_ID_FOR_S_RES( :ID_OBJ, :SMETATYPE, :SELECT_TYPE, :MEMO, :CNT, :UNCHKLIST,
                :IN_KODIR_GROUP, :IN_KODIR_PODGROUP, :IN_S_RES_ID, :IN_S_RES_RABMAT,
                :IN_S_RES_IDNORMATIV, :IN_S_RES_TAB, :IN_S_RES_NAME_ID, :IN_S_RES_ID_EDIZM, :ID_USER )
          into ID
      do
         for select first 1 NUMBER1, NUMBER2, TAB, NAME, ID_EDIZM, KOLL, NORMARASH
             from l_m29 where ID_SELF = :ID
             into NUMBER1, NUMBER2, TAB, NAME_PART, ID_EDIZM, KOLL, NORMARASH
         do
         begin
            NAME_TITLE = null;
            EDIZM = null;
            for select first 1 EDIZMNAME
                from B_GET_EDIZM ( :ID_EDIZM )
                into EDIZM
            do
               ID = ID;

            suspend;
         end
end
^


alter PROCEDURE L_SELECT_SM_STRS_ID_FOR_S_RES(
    ID_OBJ INTEGER,
    SMETATYPE INTEGER,
    SELECT_TYPE INTEGER,
    MEMO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    CNT INTEGER,
    UNCHKLIST VARCHAR(30000),
    IN_KODIR_GROUP INTEGER,
    IN_KODIR_PODGROUP INTEGER,
    IN_S_RES_ID INTEGER,
    IN_S_RES_RABMAT INTEGER,
    IN_S_RES_IDNORMATIV INTEGER,
    IN_S_RES_TAB VARCHAR(42),
    IN_S_RES_NAME_ID INTEGER,
    IN_S_RES_ID_EDIZM INTEGER,
    ID_USER INTEGER)
RETURNS (
    ID INTEGER)
AS
declare variable S_RES_ID INTEGER;
declare variable S_RES_RABMAT INTEGER;
declare variable S_RES_IDNORMATIV INTEGER;
declare variable S_RES_TAB VARCHAR(42);
declare variable S_RES_NAME_ID INTEGER;
declare variable S_RES_ID_EDIZM INTEGER;
declare variable Flag INTEGER;
declare variable main_id INTEGER;
declare variable NUMBER2 INTEGER;
declare variable SLAVEPARENT INTEGER;
declare variable ID_M29 INTEGER;
declare variable LC_ATYPE INTEGER;
begin
   ID_M29 = SMETATYPE;

   if ( IN_S_RES_RABMAT is null ) then
      IN_S_RES_RABMAT = 0;
   if ( IN_S_RES_IDNORMATIV is null ) then
      IN_S_RES_IDNORMATIV = 0;
   if ( IN_S_RES_TAB is null ) then
      IN_S_RES_TAB = '';
   if ( IN_S_RES_NAME_ID is null ) then
      IN_S_RES_NAME_ID = 0;
   if ( IN_S_RES_ID_EDIZM is null ) then
      IN_S_RES_ID_EDIZM = 0;

   if ( SMETATYPE = 16 ) then
      LC_ATYPE = 16;
   else
      LC_ATYPE = 15;

   if ( SELECT_TYPE = 0 ) then
      FOR SELECT id
          FROM A_SMETA A
          WHERE A.IDHIER IN ( SELECT IDNODE
                               FROM A_H_HIERLOADCHECKED ( :ID_USER, :ID_OBJ, :SMETATYPE, :LC_ATYPE )
                             )
                AND A.SMETATYPE = :SMETATYPE AND A.ATYPE = 17
          INTO main_id
      do
      begin
         Flag = 0;
         FOR SELECT id, rabmat, idnormativ, TAB, name_id, id_edizm
             FROM A_SMETA A
             WHERE A.slaveparent = :main_id AND A.ATYPE = 18
             INTO   id, S_RES_rabmat, S_RES_idnormativ, S_RES_TAB, S_RES_name_id, S_RES_id_edizm
         do
            if ( Flag = 0 ) then
            begin
               if ( S_RES_RABMAT is null ) then
                  S_RES_RABMAT = 0;
               if ( S_RES_IDNORMATIV is null ) then
                  S_RES_IDNORMATIV = 0;
               if ( S_RES_TAB is null ) then
                  S_RES_TAB = '';
               if ( S_RES_NAME_ID is null ) then
                  S_RES_NAME_ID = 0;
               if ( S_RES_ID_EDIZM is null ) then
                  S_RES_ID_EDIZM = 0;

               if ( ( S_RES_id = IN_S_RES_id ) or
                    (
                      ( S_RES_RABMAT = IN_S_RES_RABMAT ) and
                      ( S_RES_IDNORMATIV = IN_S_RES_IDNORMATIV ) and
                      ( S_RES_TAB = IN_S_RES_TAB ) and
                      ( S_RES_NAME_ID = IN_S_RES_NAME_ID ) and
                      ( S_RES_ID_EDIZM = IN_S_RES_ID_EDIZM )
                    )
                  ) then
               begin
                  Flag = 1;
                  id = main_id;
                  suspend;
               end
            end
      end
   else if ( SELECT_TYPE = 1 ) then
      FOR SELECT id, rabmat, idnormativ, TAB, name_id, id_edizm
          FROM A_SMETA A
          WHERE A.ID IN ( SELECT FVALUE
                          FROM S_INTFROMBLOB_SELECT ( :MEMO, :CNT )
                        )
          INTO   id, S_RES_rabmat, S_RES_idnormativ, S_RES_TAB, S_RES_name_id, S_RES_id_edizm
      do
            begin
               if ( S_RES_RABMAT is null ) then
                  S_RES_RABMAT = 0;
               if ( S_RES_IDNORMATIV is null ) then
                  S_RES_IDNORMATIV = 0;
               if ( S_RES_TAB is null ) then
                  S_RES_TAB = '';
               if ( S_RES_NAME_ID is null ) then
                  S_RES_NAME_ID = 0;
               if ( S_RES_ID_EDIZM is null ) then
                  S_RES_ID_EDIZM = 0;

               if ( ( S_RES_id = IN_S_RES_id ) or
                    (
                      ( S_RES_RABMAT = IN_S_RES_RABMAT ) and
                      ( S_RES_IDNORMATIV = IN_S_RES_IDNORMATIV ) and
                      ( S_RES_TAB = IN_S_RES_TAB ) and
                      ( S_RES_NAME_ID = IN_S_RES_NAME_ID ) and
                      ( S_RES_ID_EDIZM = IN_S_RES_ID_EDIZM )
                    )
                  ) then
                  suspend;
            end
   else if ( SELECT_TYPE = 4 ) then
      FOR SELECT id from a_smeta a
          WHERE A.IDHIER IN ( SELECT IDNODE
                               FROM A_H_HIERLOADCHECKED ( :ID_USER, :ID_OBJ, :SMETATYPE, :LC_ATYPE )
                             )
                AND A.SMETATYPE = :SMETATYPE AND A.ATYPE = 17
          into id
      do
      begin
         Flag = 0;
         for select id, rabmat, NORM_ID, TAB, name_id, idedizm
--             FROM a_s_res_select ( :ID_USER , :id , :IN_KODIR_GROUP , :IN_KODIR_PODGROUP, 0 ) S
             from a_s_res r
             where r.id_source = :id and
                r.kodir_group = :IN_KODIR_GROUP and
                r.kodir_podgroup = :IN_KODIR_PODGROUP
             INTO   S_RES_id, S_RES_rabmat, S_RES_IDNORMATIV, S_RES_TAB, S_RES_name_id, S_RES_id_edizm
         do
            if ( Flag = 0 ) then
            begin
               if ( S_RES_RABMAT is null ) then
                  S_RES_RABMAT = 0;
               if ( S_RES_IDNORMATIV is null ) then
                  S_RES_IDNORMATIV = 0;
               if ( S_RES_TAB is null ) then
                  S_RES_TAB = '';
               if ( S_RES_NAME_ID is null ) then
                  S_RES_NAME_ID = 0;
               if ( S_RES_ID_EDIZM is null ) then
                  S_RES_ID_EDIZM = 0;

               if ( ( S_RES_id = IN_S_RES_id ) or
                    (
                      ( S_RES_RABMAT = IN_S_RES_RABMAT ) and
                      ( S_RES_IDNORMATIV = IN_S_RES_IDNORMATIV ) and
                      ( S_RES_TAB = IN_S_RES_TAB ) and
                      ( S_RES_NAME_ID = IN_S_RES_NAME_ID ) and
                      ( S_RES_ID_EDIZM = IN_S_RES_ID_EDIZM )
                    )
                  ) then
               begin
                  Flag = 1;
                  suspend;
               end
            end
      end
   else if ( SELECT_TYPE = 5 ) then
      FOR SELECT FVALUE
          FROM S_INTFROMBLOB_SELECT ( :MEMO, :CNT )
          into id
      do
      begin
         Flag = 0;
         for select id, rabmat, NORM_ID, TAB, name_id, idedizm
--             FROM a_s_res_select ( :ID_USER , :id , :IN_KODIR_GROUP , :IN_KODIR_PODGROUP, 0 ) S
             from a_s_res r
             where r.id_source = :id and
                r.kodir_group = :IN_KODIR_GROUP and
                r.kodir_podgroup = :IN_KODIR_PODGROUP
             INTO   S_RES_id, S_RES_rabmat, S_RES_IDNORMATIV, S_RES_TAB, S_RES_name_id, S_RES_id_edizm
         do
            if ( Flag = 0 ) then
            begin
               if ( S_RES_RABMAT is null ) then
                  S_RES_RABMAT = 0;
               if ( S_RES_IDNORMATIV is null ) then
                  S_RES_IDNORMATIV = 0;
               if ( S_RES_TAB is null ) then
                  S_RES_TAB = '';
               if ( S_RES_NAME_ID is null ) then
                  S_RES_NAME_ID = 0;
               if ( S_RES_ID_EDIZM is null ) then
                  S_RES_ID_EDIZM = 0;

               if ( ( S_RES_id = IN_S_RES_id ) or
                    (
                      ( S_RES_RABMAT = IN_S_RES_RABMAT ) and
                      ( S_RES_IDNORMATIV = IN_S_RES_IDNORMATIV ) and
                      ( S_RES_TAB = IN_S_RES_TAB ) and
                      ( S_RES_NAME_ID = IN_S_RES_NAME_ID ) and
                      ( S_RES_ID_EDIZM = IN_S_RES_ID_EDIZM )
                    )
                  ) then
               begin
                  Flag = 1;
                  suspend;
               end
            end
      end
   else if ( SELECT_TYPE = 2 ) then
      FOR SELECT id_self, rabmat, idnormativ, TAB, id_edizm, NUMBER2, SLAVEPARENT
          FROM L_M29 M
          WHERE M.IDHIER IN ( SELECT IDHIER
                               FROM L_M29_SELECT_VISIBLE_HIER  ( :ID_OBJ, :UNCHKLIST )
                             )
                AND M.ID_M29 = :ID_M29 AND M.NUMBER3 = 0 and
                ( M.NUMBER2 <> 0 or M.RABMAT <> 0 )
          INTO   id, S_RES_rabmat, S_RES_idnormativ, S_RES_TAB, S_RES_id_edizm, NUMBER2, SLAVEPARENT
      do
            begin
               if ( S_RES_RABMAT is null ) then
                  S_RES_RABMAT = 0;
               if ( S_RES_IDNORMATIV is null ) then
                  S_RES_IDNORMATIV = 0;
               if ( S_RES_TAB is null ) then
                  S_RES_TAB = '';
               if ( S_RES_NAME_ID is null ) then
                  S_RES_NAME_ID = 0;
               if ( S_RES_ID_EDIZM is null ) then
                  S_RES_ID_EDIZM = 0;

               if ( ( S_RES_id = IN_S_RES_id ) or
                    (
                      ( S_RES_RABMAT = IN_S_RES_RABMAT ) and
                      ( S_RES_IDNORMATIV = IN_S_RES_IDNORMATIV ) and
                      ( S_RES_TAB = IN_S_RES_TAB ) and
                      ( S_RES_NAME_ID = IN_S_RES_NAME_ID ) and
                      ( S_RES_ID_EDIZM = IN_S_RES_ID_EDIZM )
                    )
                  ) then
               begin
                  if ( NUMBER2 <> 0 ) then
                     ID = SLAVEPARENT;
                  suspend;
               end
            end
   else if ( SELECT_TYPE = 3 ) then
      FOR SELECT id_self, rabmat, idnormativ, TAB, id_edizm, NUMBER2, SLAVEPARENT
          FROM L_M29 M
          WHERE M.ID_SELF IN ( SELECT FVALUE
                          FROM S_INTFROMBLOB_SELECT ( :MEMO, :CNT )
                        )
          INTO   id, S_RES_rabmat, S_RES_idnormativ, S_RES_TAB, S_RES_id_edizm, NUMBER2, SLAVEPARENT
      do
            begin
               if ( S_RES_RABMAT is null ) then
                  S_RES_RABMAT = 0;
               if ( S_RES_IDNORMATIV is null ) then
                  S_RES_IDNORMATIV = 0;
               if ( S_RES_TAB is null ) then
                  S_RES_TAB = '';
               if ( S_RES_NAME_ID is null ) then
                  S_RES_NAME_ID = 0;
               if ( S_RES_ID_EDIZM is null ) then
                  S_RES_ID_EDIZM = 0;

               if ( ( S_RES_id = IN_S_RES_id ) or
                    (
                      ( S_RES_RABMAT = IN_S_RES_RABMAT ) and
                      ( S_RES_IDNORMATIV = IN_S_RES_IDNORMATIV ) and
                      ( S_RES_TAB = IN_S_RES_TAB ) and
                      ( S_RES_NAME_ID = IN_S_RES_NAME_ID ) and
                      ( S_RES_ID_EDIZM = IN_S_RES_ID_EDIZM )
                    )
                  ) then
               begin
                  if ( NUMBER2 <> 0 ) then
                     ID = SLAVEPARENT;
                  suspend;
               end
            end
END
^


CREATE TRIGGER L_SSR_FORMULS_BU FOR L_SSR_FORMULS
ACTIVE BEFORE UPDATE POSITION 0
as
begin
   if ( new.i_val is null ) then
      new.i_val = 0;
end
^


CREATE TRIGGER L_SSR_BU FOR L_SSR
ACTIVE BEFORE UPDATE POSITION 0
as
begin
   if ( new.i1_val is null ) then
      new.i1_val = 0;
   if ( new.i2_val is null ) then
      new.i3_val = 0;
   if ( new.i3_val is null ) then
      new.i3_val = 0;
   if ( new.i4_val is null ) then
      new.i4_val = 0;
   if ( new.i5_val is null ) then
      new.i5_val = 0;
   if ( new.i6_val is null ) then
      new.i6_val = 0;
end
^



alter PROCEDURE L_BUFER_SELECT_ONE(
    IDUSER INTEGER,
    IDBUFER INTEGER,
    IDZONE INTEGER,
    FROM_RABMAT INTEGER)
RETURNS (
    IDNORMY INTEGER,
    RABMAT INTEGER,
    IDNAME INTEGER,
    IDUNIQUE INTEGER,
    TAB VARCHAR(42),
    FRTCH VARCHAR(250),
    ALTTAB VARCHAR(250),
    IDEDIZM INTEGER,
    EDIZMNAME VARCHAR(100),
    EDIZMFULLNAME VARCHAR(250),
    EDIZMKOEF DOUBLE PRECISION,
    IDABCOKP INTEGER,
    COMMENT VARCHAR(15),
    OKP VARCHAR(15),
    FRESN VARCHAR(21),
    RAZRAD DOUBLE PRECISION,
    BA DOUBLE PRECISION,
    BB DOUBLE PRECISION,
    BC DOUBLE PRECISION,
    BD DOUBLE PRECISION,
    BE DOUBLE PRECISION,
    BF DOUBLE PRECISION,
    BG DOUBLE PRECISION,
    BH DOUBLE PRECISION,
    BI DOUBLE PRECISION,
    BJ DOUBLE PRECISION,
    PA DOUBLE PRECISION,
    PB DOUBLE PRECISION,
    PC DOUBLE PRECISION,
    PD DOUBLE PRECISION,
    PE DOUBLE PRECISION,
    MA DOUBLE PRECISION,
    MB DOUBLE PRECISION,
    MC DOUBLE PRECISION,
    MD DOUBLE PRECISION,
    ME DOUBLE PRECISION,
    MF DOUBLE PRECISION,
    MG DOUBLE PRECISION,
    MH DOUBLE PRECISION,
    MI DOUBLE PRECISION,
    MJ DOUBLE PRECISION,
    MK DOUBLE PRECISION,
    ML DOUBLE PRECISION,
    MM DOUBLE PRECISION,
    MN DOUBLE PRECISION,
    MO DOUBLE PRECISION,
    MP DOUBLE PRECISION,
    MQ DOUBLE PRECISION,
    MR DOUBLE PRECISION,
    MS DOUBLE PRECISION,
    MT DOUBLE PRECISION,
    VRPZ INTEGER,
    NTR INTEGER,
    BRUTTO DOUBLE PRECISION,
    NETTO DOUBLE PRECISION,
    VB DOUBLE PRECISION,
    VN DOUBLE PRECISION,
    PREISK VARCHAR(42),
    POSPREISK VARCHAR(42),
    MBETON DOUBLE PRECISION,
    MRKBETON VARCHAR(15),
    MMASHINE VARCHAR(25),
    VBETON DOUBLE PRECISION,
    TKALK VARCHAR(50),
    PUNKTIND VARCHAR(42),
    ZONE_BB DOUBLE PRECISION,
    ZONE_BC DOUBLE PRECISION,
    ZONE_BD DOUBLE PRECISION,
    ZONE_BE DOUBLE PRECISION,
    NAME BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    NAME_TITLE BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    NAME_PART BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    IDTCH INTEGER,
    IDSOSTAV INTEGER,
    IDTCARD INTEGER,
    IDESN INTEGER,
    IDPICTURE INTEGER,
    IDPOSTAV INTEGER,
    ISESN SMALLINT,
    IDWITHESN INTEGER,
    IDQUALIFIER INTEGER,
    ID_UNIQUE INTEGER,
    IDPODGROUP INTEGER,
    ISGROUPOKP INTEGER,
    IDNORMA INTEGER,
    TYPE_TRUD INTEGER)
AS
DECLARE VARIABLE IDALTEDIZM INTEGER;
DECLARE VARIABLE ZONE_BA DOUBLE PRECISION;
DECLARE VARIABLE rabmat1 INTEGER;
DECLARE VARIABLE podgroup INTEGER;
BEGIN
   if ( ( FROM_RABMAT is null ) or ( FROM_RABMAT = -1 ) ) then
   begin
      select first 1 rabmat, podgroup
      from b_bufer b
      where b.id = :IDBUFER into rabmat1, podgroup;

      if ( podgroup > 1 ) then
         FROM_RABMAT = 0;
      else if ( rabmat1 = 1 ) then
         FROM_RABMAT = 0;
      else
         FROM_RABMAT = 1;
   end
   if ( FROM_RABMAT = 0 ) then
--   if ( ( FROM_RABMAT is null ) or ( FROM_RABMAT = 0 ) ) then
      for select IDNORMY, RABMAT, ID_UNIQUE, TAB, IDPODGROUP, ISGROUPOKP,
                 IDEDIZM, EDIZMNAME, EDIZMFULLNAME, IDNORMA, TABNORMA, COMMENT,
                 MMASHINE, CENA, RAZRAD, PUNKTIND, IDPOSTAV, VRPZ, NTR,
                 ZONE_CENA, NAME_TITLE, NAME_PART, IDQUALIFIER, TYPE_TRUD
          from S_BUFER_RESURS_SELECT_ONE ( :IDUSER, :IDBUFER, :IDZONE )  
          into   IDNORMY, RABMAT, ID_UNIQUE, TAB, IDPODGROUP, ISGROUPOKP,
                 IDEDIZM, EDIZMNAME, EDIZMFULLNAME, IDNORMA, ALTTAB, COMMENT,
                 MMASHINE, BA, RAZRAD, PUNKTIND, IDPOSTAV, VRPZ, NTR,
                 ZONE_BA, NAME_TITLE, NAME_PART, IDQUALIFIER, TYPE_TRUD
      do
      begin
         IDNAME = null;
         NAME = NULL;
         if ( IDNAME is null ) then
            select first 1 IDNAME from b_abc_okp where ID = :IDNORMY into IDNAME;
         if ( IDNAME is null ) then
            select first 1 IDNAME from b_trud where ID = :IDNORMY into IDNAME;
         if ( IDNAME is null ) then
            select first 1 IDNAME from b_rabmat where ID = :IDNORMY into IDNAME;
         suspend;
      end
   else
   begin
      ID_UNIQUE = 0;
      IDPODGROUP = 1;
      ISGROUPOKP = 1;
      IDNORMA = null;
      TYPE_TRUD = 0;

      for select IDNORMY, RABMAT, IDNAME, IDUNIQUE, TAB, FRTCH, ALTTAB,
                 IDEDIZM, EDIZMNAME, EDIZMFULLNAME, EDIZMKOEF,
                 IDABCOKP, COMMENT, OKP, FRESN, RAZRAD,
                 BA, BB, BC, BD, BE, BF, BG, BH, BI, BJ,
                 PA, PB, PC, PD, PE,
                 MA, MB, MC, MD, ME, MF, MG, MH, MI, MJ, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT,
                 VRPZ, NTR, BRUTTO, NETTO, VB, VN, PREISK, POSPREISK,
                 MBETON, MRKBETON, MMASHINE, VBETON, TKALK, PUNKTIND,
                 ZONE_BB, ZONE_BC, ZONE_BD, ZONE_BE,
                 NAME, NAME_TITLE, NAME_PART, IDTCH, IDSOSTAV, IDTCARD,
                 IDESN, IDPICTURE, IDPOSTAV, ISESN, IDWITHESN, IDQUALIFIER
          from S_BUFER_RABMAT_SELECT_ONE ( :IDUSER, :IDBUFER, :IDZONE )
          into   IDNORMY, RABMAT, IDNAME, IDUNIQUE, TAB, FRTCH, ALTTAB,
                 IDEDIZM, EDIZMNAME, EDIZMFULLNAME, EDIZMKOEF,
                 IDABCOKP, COMMENT, OKP, FRESN, RAZRAD,
                 BA, BB, BC, BD, BE, BF, BG, BH, BI, BJ,
                 PA, PB, PC, PD, PE,
                 MA, MB, MC, MD, ME, MF, MG, MH, MI, MJ, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT,
                 VRPZ, NTR, BRUTTO, NETTO, VB, VN, PREISK, POSPREISK,
                 MBETON, MRKBETON, MMASHINE, VBETON, TKALK, PUNKTIND,
                 ZONE_BB, ZONE_BC, ZONE_BD, ZONE_BE,
                 NAME, NAME_TITLE, NAME_PART, IDTCH, IDSOSTAV, IDTCARD,
                 IDESN, IDPICTURE, IDPOSTAV, ISESN, IDWITHESN, IDQUALIFIER
      do
         suspend;
   end
END
^


alter PROCEDURE L_M29_COPY_FROM_SEARCH(
    ID_M29 INTEGER,
    ID_USER INTEGER,
    COUNTREC INTEGER,
    IDRECS BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    INSERTTO INTEGER,
    IDHIER INTEGER,
    USE_ESN INTEGER,
    PAGEINDEX INTEGER)
AS
DECLARE VARIABLE I INTEGER;
DECLARE VARIABLE IDREC INTEGER;
DECLARE VARIABLE INSKODIRMODE INTEGER;
DECLARE VARIABLE ID_ZONE INTEGER;
DECLARE VARIABLE ISZONEFIND INTEGER;
DECLARE VARIABLE INS_WITH_RES INTEGER;
DECLARE VARIABLE RES_TOLKO_NEUCHT_RES INTEGER;
DECLARE VARIABLE ID_SPIS INTEGER;
DECLARE VARIABLE M29_GROUP INTEGER;
DECLARE VARIABLE M29_PODGROUP INTEGER;
DECLARE VARIABLE SLAVEPARENT INTEGER;
DECLARE VARIABLE NEW_NUMBER1 INTEGER;
DECLARE VARIABLE NEW_NUMBER2 INTEGER;
DECLARE VARIABLE NEW_NUMBER3 INTEGER;
DECLARE VARIABLE NEW_ID_SELF INTEGER;
DECLARE VARIABLE IDNORMATIV INTEGER;
DECLARE VARIABLE ID INTEGER;
DECLARE VARIABLE IDNAME INTEGER;
DECLARE VARIABLE ID_UNIQUE INTEGER;
DECLARE VARIABLE TAB VARCHAR(60);
DECLARE VARIABLE ALTTAB VARCHAR(250);
DECLARE VARIABLE ABC_OKP_TAB VARCHAR(60);
DECLARE VARIABLE RABMAT INTEGER;
DECLARE VARIABLE IDEDIZM INTEGER;
DECLARE VARIABLE IDABCOKP INTEGER;
DECLARE VARIABLE COMMENT VARCHAR(60);
DECLARE VARIABLE IDNORMA INTEGER;
DECLARE VARIABLE IDPODGROUP INTEGER;
DECLARE VARIABLE ISGROUPOKP INTEGER;
DECLARE VARIABLE BA DOUBLE PRECISION;
DECLARE VARIABLE BB DOUBLE PRECISION;
DECLARE VARIABLE BC DOUBLE PRECISION;
DECLARE VARIABLE BD DOUBLE PRECISION;
DECLARE VARIABLE BE DOUBLE PRECISION;
DECLARE VARIABLE CCURRENT_BA DOUBLE PRECISION;
DECLARE VARIABLE CCURRENT_BB DOUBLE PRECISION;
DECLARE VARIABLE CCURRENT_BC DOUBLE PRECISION;
DECLARE VARIABLE CCURRENT_BD DOUBLE PRECISION;
DECLARE VARIABLE CCURRENT_BE DOUBLE PRECISION;
DECLARE VARIABLE NAME BLOB;
DECLARE VARIABLE NORMARASH DOUBLE PRECISION;
DECLARE VARIABLE CCURRENT_ZONE INTEGER;
DECLARE VARIABLE CCURRENT DOUBLE PRECISION;
DECLARE VARIABLE RES_UCH INTEGER;
DECLARE VARIABLE ABC_OKP_CENA DOUBLE PRECISION;
DECLARE VARIABLE ABC_OKP_CCURRENT INTEGER;
DECLARE VARIABLE ID_BLOB_GEN INTEGER;
DECLARE VARIABLE NORM_GUID VARCHAR(100);
DECLARE VARIABLE RABMATMASK INTEGER;
DECLARE VARIABLE use_trud_res INTEGER;
DECLARE VARIABLE use_mash_res INTEGER;
DECLARE VARIABLE use_mat_res INTEGER;
DECLARE VARIABLE CAN_INSERT_RECORD INTEGER;
DECLARE VARIABLE FROM_RABMAT INTEGER;
DECLARE VARIABLE ISH_NEW_NUMBER1 INTEGER;
DECLARE VARIABLE INS_AS_MAIN INTEGER;
DECLARE VARIABLE NEW_ATYPE INTEGER;
begin
   if ( not IDRECS is null ) then
   begin
       /* clear blob */
       ID_BLOB_GEN = GEN_ID(B_GEN_TEMP, 1);
       INSERT INTO B_TEMP_BLOB(ID, BLOB1) VALUES (:ID_BLOB_GEN, :IDRECS);
       SELECT BLOB1 FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN INTO :IDRECS;
       DELETE FROM B_TEMP_BLOB WHERE ID = :ID_BLOB_GEN;
   end

   ID_SPIS = 0; /* copy only main part ( don't copy spisan. ) */

   /* Calculate start values for insert */

   NEW_NUMBER1 = 0;
   NEW_NUMBER2 = 0;
   NEW_NUMBER3 = 0;
   SLAVEPARENT = 0;

   /* read params from m29 */
   for select RES_TOLKO_NEUCHT_RES, RES_ZANOSIT_S_RES , RES_APPLY_TAB , KODIR_GROUP , KODIR_PODGROUP , RABMATMASK
       from a_o_m29params where number = :id_m29
       into RES_TOLKO_NEUCHT_RES, INS_WITH_RES , inskodirmode , M29_GROUP , M29_PODGROUP , RABMATMASK
   do
      inskodirmode = inskodirmode + 1;
   for select id_zone from l_m29_reestr where id_m29 = :id_m29 and id_spis = 0 into :id_zone
   do
      id_zone = id_zone;

   use_trud_res = 1;
   use_mash_res = 1;
   use_mat_res  = 1;
   if ( not RABMATMASK is null ) then
   begin
      if ( getbit ( RABMATMASK , 1 ) = 0 ) then
         use_trud_res = 0;
      if ( getbit ( RABMATMASK , 2 ) = 0 ) then
          use_mash_res = 0;
      if ( getbit ( RABMATMASK , 3 ) = 0 ) then
          use_mat_res  = 0;
   end

   /* insert into specified plase */
   for select NUMBER1 , NUMBER2 , NUMBER3 , SLAVEPARENT , IDHIER from l_m29 m where m.id_self = :INSERTTO
       into   NEW_NUMBER1 , NEW_NUMBER2 , NEW_NUMBER3 , SLAVEPARENT , IDHIER
   do
      I = I;

/*
   FROM_RABMAT = 1;
   if ( PAGEINDEX = 1 ) then
      FROM_RABMAT = 0;

   ISH_NEW_NUMBER1 = NEW_NUMBER1;
   if ( ( FROM_RABMAT = 0 ) and ( SLAVEPARENT = 0 ) and ( NEW_NUMBER1 <> 0 ) ) then
      SLAVEPARENT = INSERTTO;
*/

   INS_AS_MAIN = 0;
   if ( PAGEINDEX = 0 ) then
      INS_AS_MAIN = 1;

   ISH_NEW_NUMBER1 = NEW_NUMBER1;
   if ( ( INS_AS_MAIN = 0 ) and ( SLAVEPARENT = 0 ) and ( NEW_NUMBER1 <> 0 ) ) then
      SLAVEPARENT = INSERTTO;


   /* Start loop */
   i = 0;

   while ( i < :countrec ) do
   begin

      idrec = readintfromblob(:idrecs, :i);

      ID = 0;

      /* process current record from buffer(blob) */
      for select IDNORMY , NAME , IDUNIQUE , TAB , RABMAT , ALTTAB , IDEDIZM , IDABCOKP , COMMENT , BA , BB , BC , BD , BE, IDPODGROUP, ISGROUPOKP , IDNAME
--          from s_bufer_rabmat_select_one ( :id_user , :idrec , :id_zone )
--          from L_BUFER_SELECT_ONE ( :id_user , :idrec , :id_zone , :FROM_RABMAT )
          from L_BUFER_SELECT_ONE ( :id_user , :idrec , :id_zone , -1 )
          into   ID , NAME , ID_UNIQUE , TAB , RABMAT , ALTTAB , IDEDIZM , IDABCOKP , COMMENT , BA , BB , BC , BD , BE, IDPODGROUP, ISGROUPOKP , IDNAME
      do
      begin
            if ( NAME is null ) then
                execute procedure b_getname ( :id_user, :idname ) returning_values ( :name );

--            IDPODGROUP = 1; /* rabmat */
--            ISGROUPOKP = 0;

--            if ( ( ISH_NEW_NUMBER1 = 0 ) or ( FROM_RABMAT <> 0 ) ) then
            if ( ( ISH_NEW_NUMBER1 = 0 ) or ( INS_AS_MAIN <> 0 ) ) then
            begin
               SLAVEPARENT = 0;
               NEW_NUMBER1 = NEW_NUMBER1 + 1;
               NEW_NUMBER2 = 0;
            end
            else
               NEW_NUMBER2 = NEW_NUMBER2 + 1;
--            NEW_NUMBER1 = NEW_NUMBER1 + 1;
--            NEW_NUMBER2 = 0;
            NEW_NUMBER3 = 0;

            if ( BA is null ) then
               BA = 0.0;
            if ( ID_UNIQUE is null ) then
               ID_UNIQUE = 0;
            if ( ISGROUPOKP is null ) then
               ISGROUPOKP = 0;

            execute procedure L_EXP_GET_NORM_GUID ( :ID, 1, :IDPODGROUP, :RABMAT, :NORM_GUID, :ID_USER )
                returning_values ( :NORM_GUID );

            NEW_ATYPE = 17;
            if ( NEW_NUMBER2 <> 0 ) then
               NEW_ATYPE = 18;

            /* Insert new record */
            execute procedure L_M29_INSERTREC ( ID_M29 , ID_SPIS , IDHIER ,
                NEW_NUMBER1 , NEW_NUMBER2 , NEW_NUMBER3 , SLAVEPARENT , INSERTTO ,
                NEW_ATYPE , 1 , RABMAT , ID_USER , M29_PODGROUP )
            returning_values ( :NEW_ID_SELF );

            INSERTTO    = NEW_ID_SELF;
--            if ( ( ISH_NEW_NUMBER1 = 0 ) or ( FROM_RABMAT <> 0 ) ) then
            if ( ( ISH_NEW_NUMBER1 = 0 ) or ( INS_AS_MAIN <> 0 ) ) then
               SLAVEPARENT = NEW_ID_SELF;

            /* copy values to new record */
            update l_m29 set
               TAB = :TAB, ALTTAB = substring ( :alttab from 1 for 60 ), NAME = :NAME, ID_EDIZM = :IDEDIZM, EDIZM_TYPE = 0,
               KOLL = 0, LDATE = 'now', NORMARASH = 0, RASHODALL = 0, CSMETN = :BA, CSMETNALL = 0,
               ASMETA_ID = 0, ASMETARES_ID = 0, IDNORMATIV = :ID, IDNORMATIVUNIQ = :ID_UNIQUE,
               KODIR_GROUP = :M29_GROUP, KODIR_PODGROUP = :IDPODGROUP, ISGROUPOKP = :ISGROUPOKP,
               NORM_GUID = :NORM_GUID
            where ID_SELF = :NEW_ID_SELF;


            /* copy values to l_m29_spis */
            CCURRENT = 0;
            CCURRENT_ZONE = 0;
            if ( id_zone = -3 ) then /* from normy */
            begin
               CCURRENT_ZONE = id_zone;
               CCURRENT = BA;
            end
            else if ( id_zone > 0 ) then
            begin
               execute procedure  L_FILL_CCURRENT ( :ID, :RABMAT, :idpodgroup, 0, 0, :id_zone, :id_user )
                       returning_values ( :CCURRENT , :ISZONEFIND );
               if ( ISZONEFIND <> 0 ) then
                  CCURRENT_ZONE = id_zone;
            end
            if ( CCURRENT_ZONE <> 0 ) then
               update l_m29_spis set
                   CCURRENT_ZONE = :CCURRENT_ZONE,
                   CCURRENT = :CCURRENT,
                   CCURRENTALL = 0
               where (ID_M29 = :ID_M29) and (ID_SPIS = :ID_SPIS) and (ID_REC = :NEW_ID_SELF);


         /* Insert resources */
         if ( INS_WITH_RES <> 0 ) then
         begin

            for select ID_SELF, PODGROUP, RABMAT, NORMA_RASH, IDNAME, IDEDIZM, TAB, ALTTAB, RES_UCH,
                     BA, BB, BC, BD, BE, CCURRENT_BA, CCURRENT_BB, CCURRENT_BC, CCURRENT_BD, CCURRENT_BE,
                     CCURRENT_ZONE, ABC_OKP_ISGROUPOKP, ID_UNIQUE, ID_ABC_OKP, ABC_OKP_TAB, ABC_OKP_CENA, ABC_OKP_CCURRENT, COMMENT,
                     NORM_GUID
                from L_FB_READ_RESOURCES ( :ID, :IDPODGROUP, :RABMAT, :M29_GROUP, :M29_PODGROUP, :ID_USER, :ID_ZONE, :USE_ESN )
                into IDNORMATIV, IDPODGROUP, RABMAT, NORMARASH, idname, IDEDIZM, TAB, ALTTAB, RES_UCH,
                     BA, BB, BC, BD, BE, CCURRENT_BA, CCURRENT_BB, CCURRENT_BC, CCURRENT_BD, CCURRENT_BE,
                     CCURRENT_ZONE, ISGROUPOKP, ID_UNIQUE, IDABCOKP, ABC_OKP_TAB, ABC_OKP_CENA, ABC_OKP_CCURRENT, COMMENT,
                     NORM_GUID
            do
               if ( IDNORMATIV <> 0 ) then
                 if ( ( RES_TOLKO_NEUCHT_RES = 0 ) or ( RES_UCH is null ) or ( RES_UCH = 0 ) ) then
                 begin

                  CAN_INSERT_RECORD = 0;
                  if ( ( ( RABMAT = 1 ) and ( use_trud_res = 1 ) ) or
                       ( ( RABMAT = 2 ) and ( use_mash_res = 1 ) ) or
                       ( ( RABMAT = 3 ) and ( use_mat_res = 1 ) ) ) then
                     CAN_INSERT_RECORD = 1;

                  if ( CAN_INSERT_RECORD = 1 ) then
                  begin

                    execute procedure b_getname ( :id_user, :idname ) returning_values ( :name );
                    execute procedure L_FILL_CENA_FROM_SEARCH_RESULTS ( rabmat , IDPODGROUP , BA , BB , BC , BD , BE , ABC_OKP_CENA )
                            returning_values BA;

                    if ( ID_UNIQUE is null ) then
                       ID_UNIQUE = 0;
                    if ( ISGROUPOKP is null ) then
                       ISGROUPOKP = 0;
                    if ( NORMARASH is null ) then
                       NORMARASH = 0;
                    if ( rabmat is null ) then
                       rabmat = 0;
                    if ( idedizm = 0 ) then
                       idedizm = null;

                    CCURRENT_BA = 0;
                    if ( ID_ZONE = -3 ) then /* from normy */
                       CCURRENT_BA = BA;
                    else                     /* from zony */
                       execute procedure L_FILL_CENA_FROM_SEARCH_RESULTS ( rabmat , IDPODGROUP , CCURRENT_BA , CCURRENT_BB , CCURRENT_BC , CCURRENT_BD , CCURRENT_BE , ABC_OKP_CCURRENT )
                            returning_values CCURRENT_BA;

                    if ( CCURRENT_ZONE is null ) then
                       CCURRENT_ZONE = 0;

                    execute procedure L_FILL_TABS_FROM_SEARCH_RESULTS ( IDPODGROUP , inskodirmode , TAB , ALTTAB , COMMENT , ABC_OKP_TAB )
                            returning_values TAB , ALTTAB;


                    NEW_NUMBER2 = NEW_NUMBER2 + 1;

                    /* Insert new record */
                    execute procedure L_M29_INSERTREC ( ID_M29 , ID_SPIS , IDHIER ,
                        NEW_NUMBER1 , NEW_NUMBER2 , NEW_NUMBER3 , SLAVEPARENT , INSERTTO ,
                        18 , 2 , RABMAT , ID_USER , M29_PODGROUP )
                         returning_values ( :NEW_ID_SELF );

                    INSERTTO    = NEW_ID_SELF;

                    /* copy values to new record */
                    update l_m29 set
                      TAB = :TAB, ALTTAB = :ALTTAB, NAME = :NAME, ID_EDIZM = :IDEDIZM, EDIZM_TYPE = 0,
                      KOLL = 0, LDATE = 'now', NORMARASH = :NORMARASH, RASHODALL = 0, CSMETN = :BA, CSMETNALL = 0,
                      ASMETA_ID = 0, ASMETARES_ID = 0, IDNORMATIV = :IDNORMATIV, IDNORMATIVUNIQ = :ID_UNIQUE,
                      KODIR_GROUP = :M29_GROUP, KODIR_PODGROUP = :IDPODGROUP, ISGROUPOKP = :ISGROUPOKP, NORM_GUID = :NORM_GUID
                    where ID_SELF = :NEW_ID_SELF;
                    if ( CCURRENT_ZONE <> 0 ) then
                       update l_m29_spis set
                          CCURRENT_ZONE = :CCURRENT_ZONE,
                          CCURRENT = :CCURRENT_BA,
                          CCURRENTALL = 0
                       where (ID_M29 = :ID_M29) and (ID_SPIS = :ID_SPIS) and (ID_REC = :NEW_ID_SELF);

                  end

                 end
         end
      end

      i = i + 1;

   end

end
^